/*==============================================================================
PART 3: Summary Statistics Table (Table A1)
==============================================================================
Purpose:
This script generates Table A1 of the manuscript, which presents summary
statistics for key bank characteristics for the full sample and a subsample
of large banks (assets >= $100 billion) as of a specific quarter (2021q4).

Input:
- $path_clean/analysis_ready_data.dta (Prepared bank-quarter panel dataset)

Output:
- $path_tables/table_a1.tex (LaTeX file containing Table 1)

Last updated: July 03, 2025
==============================================================================*/

display "--- Starting Part 3A: Table A1: Summary Statistics Table ---"

**===============================================================================
* Step 1: Generate Summary Statistics and Export Table
*===============================================================================
* Purpose: Calculate summary statistics for the specified variables and samples
* and export the results to a LaTeX table file.

* Clear any previous estimation results stored by eststo
eststo clear

* Store summary statistics for the full sample in dec2021 period
eststo: estpost summarize assets_bill loans_assets securities_assets cash_assets equity_assets domdep_assets uninsuredsh_domdep net_nonintexp_assets if yq == yq(2021,4), d

* Store summary statistics for the large bank subsample (assets >= $100 billion) in dec2021 period
eststo: estpost summarize assets_bill loans_assets securities_assets cash_assets  equity_assets domdep_assets uninsuredsh_domdep  net_nonintexp_assets if yq == yq(2021,4) & assets_bill>=100, d

* Export the stored summary statistics to a LaTeX table
* The esttab command is configured to produce a two-column table (All banks, Large banks)
* with mean and standard deviation, specific variable labels, and custom LaTeX formatting.
esttab using "$path_tables/table_a1.tex",  ///
  main(mean %12.2fc) aux(sd %12.2fc) replace ///
  prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
          "\begin{tabular*}{0.9\textwidth}{@{\hskip\tabcolsep\extracolsep\fill}l*{2}{c}}" ///
          "\hline\hline" ///
          " &\multicolumn{1}{c}{All banks}" ///
          "&\multicolumn{1}{c}{Large banks}" ///
          "\\\cmidrule(lr){2-2}" ///
          "\cmidrule(lr){3-3}") ///
  coeflabels(assets_bill "Assets (\\$ bill)" ///
             loans_assets "Loans \%" ///
             securities_assets "Securities \%" ///
             cash_assets "Cash \%" ///
             net_nonintexp_assets "Net non-interest expenses \%" ///
             equity_assets "Equity \%" ///
             domdep_assets "Domestic deposits \%" ///
             uninsuredsh_domdep "Uninsured \%") ///
   nonote label msign($-$) alignment(ccc) nomtitles ///
   postfoot("\hline\hline \end{tabular*}}")

display "--- Summary Statistics Table generation completed ---"
